
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   LAMBON.H - Labmon Prototypes and Definitions
// 
//
//   DESCRIPTION
//
//   Prototypes for the main Labmon processing functions, and definitions
//   for some the constants and types used by them.
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Include\Archives\LABMON.H_V  $
//   
//      Rev 1.15   06 Nov 1998 17:47:16   phungh
//   Labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the write to file code
//   portion out of the interrupt hander so that
//   data is not missed because of time spent
//   too long in the interrupt handler.
//   
//      Rev 1.4   Jul 09 1997 09:34:52   COLEJ
//   Multiple Changes...
//   
//      Rev 1.3   Feb 25 1997 14:30:20   COLEJ
//   header changes to coinside with .c changes
//   
//      Rev 1.2   Feb 12 1997 16:04:38   COLEJ
//    
//   
//      Rev 1.1   Aug 14 1996 08:23:34   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:54:24   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

typedef unsigned short tDATATYPE;
#define NC_BINARY 1  // NavCore binary
#define NC_NMEA   2  // NavCore NMEA-0183
#define Z_BINARY  4  // Zodiac binary
#define Z_NMEA    8  // Zodiac NMEA-0183
#define ASCII     16 // Terminal ASCII
#define BINARY    32 // Terminal Binary

#define   TICKPERSEC      18.2
#define   PI    3.14159265358979323846 
#define   D2R   PI/180.0
#define   R2D   180.0/PI  
#define   D2M   110865.92  // assumes 24,800 mile circumference for earth

#define   BYTE  unsigned char

#define MAX_TX_BUFFER       1024  
#define MAX_RX_BUFFER       8192  
#define MAX_MSG_BUFFER      1024  
#define MAX_DGPS_RX_BUFFER  1024   
 
#define max_fpos    1024 /* file position circular buffer size */

#define COM1 0x3F8      /* I/O address of COM1         */
#define COM2 0x2F8      /* I/O address of COM2         */
#define EOI  0x20       /* End of interrupt            */

#define IRQ3 0xF7      /* Interrupt mask for COM2    */
#define IRQ4 0xEF      /* Interrupt mask for COM1    */
#define IRQ5 0xDF      /* Interrupt mask for COM3    */

#define INT_0B 0x0B    /* Interrupt for COM2         */
#define INT_0C 0x0C    /* Interrupt for COM1         */
#define INT_0D 0x0D    /* Interrupt for COM3         */

                      /* 8251 UART registers: offset from base   */

#define IER 1         /* Interrupt Enable Register            */
#define IIR 2         /* Interrupt Identification Register   */
#define LCR 3         /* Line Control Register      */
#define MCR 4         /* Modem Control Register      */
#define LSR 5         /* Line Status Register         */
#define MSR 6         /* Modem Status Register      */

enum { GETKEY, CLEAR_WAIT };
typedef struct {
      unsigned key;        /* Value returned from the functions. */
      unsigned scan;       /* Scan code value.                   */
      unsigned ascii;      /* ASCII code value.                  */
      unsigned shift;      /* Shift status value.                */
} KeyboardType;

//enum { OFF, ON };
//enum { USERINPUT, SEVS, LIVE };

/* Define scan codes for the function keys. */

// keyboard processing code doesn't currently suppport F11, F12, use codes
enum {  F1 =  59, F2, F3, F4, F5, F6, F7, F8, F9, F10,};
enum { sF1 =  84, sF2, sF3, sF4, sF5, sF6, sF7, sF8, sF9, sF10 }; /* shift   */
enum { cF1 =  94, cF2, cF3, cF4, cF5, cF6, cF7, cF8, cF9, cF10 }; /* control */
enum { aF1 = 104, aF2, aF3, aF4, aF5, aF6, aF7, aF8, aF9, aF10 }; /* alt */


void  close_data_file             (short);
short get_byte                    (void); 
short read_byte                   (void); 
unsigned short get_byte_2         (void);
void  init_serial_io              (short);
void  _interrupt _far new_serial  (void);
void  process_kbd                 (KeyboardType);
void  process_msg                 (void);
void  reset_mess_counters         (void);
void  send_byte                   (BYTE);
void  send_byte_2                 (BYTE);
void  send_msg                    (BYTE*);
void  msg_106                     (void);
void  ReleaseIRQ                  (short IRQ);
void  procrtcm                    (void);
void  show_count                  (void); 
void  show_filter                 (short); 
short extract                     (char *b,char *f[],short n);  
void  reset_count                 (void);  
void  clear_count                 (void);  
void  wait                        (float);
short get_msgid_from_field_name   (void);
short IsIrqAvail                  (short);
extern short menu_on;
void WatchDog(void);
void clear_screen(void);
short get_send_file(void);
void Send_File(void);
short OpenGPS(short port, short IRQ, long rate, char gpsprty, short gpsnbit, short gpssbit);

// function in flash.c
void Send_RFB(void);

// function in title.c
void TitleScreen(unsigned short Mode);
